package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Naxas_F_bumper_3 extends Bumper
{
	public Naxas_F_bumper_3( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Naxas front bumper 3";

		value = 2600;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.naxas:0x000000F8r, "FL blinker", actcolor, optical, power );
			addPart( cars.cat_04.naxas:0x000000F9r, "FR blinker", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000F8r, "FL blinker", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000F9r, "FR blinker", actcolor, optical, power );
		}
	}
}
